<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_obf', language 'es', version '4.3'.
 *
 * @package     local_obf
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitycompletedby'] = 'Completado por';
$string['addcourses'] = 'Añadir cursos seleccionados';
$string['addcriteria'] = 'Crear nueva regla de concesión';
$string['addemaildescription'] = 'Escriba su dirección Email. Si la dirección no ha sido verificada, se enviará un código para verificación a esa dirección.';
$string['addemailheader'] = 'Añada y verifique su dirección Email';
$string['addnew'] = 'Añadir nuevo';
$string['addnewclient'] = 'Añadir nuevo cliente';
$string['addnewcriterion'] = 'Añadir curso';
$string['addnewoauth2'] = 'Nueva conexión OAuth2 API';
$string['apidataretrieve'] = 'Eventos de emisión de insignias';
$string['apidataretrieveall'] = 'Mostrar todas las insignias emitidas con OBF';
$string['apidataretrievedesc'] = 'Si Usted selecciona a "Todas" las insignias emitidas directamente desde la Fábrica de Insignias Abiertas, serán incluidas en todos los resultados (de insignias).';
$string['apidataretrievelocal'] = 'Mostrar solamente insignias emitidas desde este sistema';
$string['apierror'] = 'No se puedo encontrar el servicio OBF. Por favor revise la URL de la API en los ajustes.';
$string['apierror0'] = 'La petición al servicio Open Badge Factory falló. El administrador del sitio tiene que configurar los ajustes del plugin.';
$string['apierror400'] = 'La petición al servicio OBF falló debido a un error/falta de un parámetro.';
$string['apierror403'] = 'Open Badge Factory denegó la petición. El administrador del sitio tiene que validar de nuevo el cliente Open Badge Factory.';
$string['apierror404'] = 'No se puedo encontrar el servicio OBF. Por favor revise la URL de la API en los ajustes.';
$string['apierror405'] = '405 Método no permitido';
$string['apierror411'] = '411 Longitud requerida';
$string['apierror413'] = '413 Tamaño de petición demasiado grande';
$string['apierror429'] = '429 Demasiadas peticiones';
$string['apierror495'] = '495 Error de certificado';
$string['apierror496'] = 'El certificado tiene que ser generado antes de que Open Badge Factory se pueda usar con Moodle. Inicia sesión en Open Badge Factory para conseguir el vale necesario y pégalo en el campo de debajo.';
$string['apierror500'] = '500 Error interno del servidor';
$string['apierror502'] = '502 Gateway erróneo';
$string['apierror503'] = 'El servicio OBF está indisponible temporalmente. Por favor inténtelo de nuevo más tarde.';
$string['authenticate'] = 'Autenticar';
$string['authenticationsuccess'] = 'Autenticación satisfactoria.';
$string['availablecategories'] = 'Categorías disponible';
$string['availablecategorieshelp'] = 'Seleccionar las categorías de insignia de cuales insignias puedan ser usadas en eventos de emisión de esta institución. Si ninguna de las categorías es seleccionada, las insignias de todas las categorías pueden ser emitidas.';
$string['availablecategoriesselect'] = 'Categorías';
$string['back'] = 'Regresar';
$string['backpackconfig'] = 'Configuraciones de Mochila de Mozilla';
$string['backpackconnected'] = 'Conectado';
$string['backpackdisconnected'] = 'Desconectado';
$string['backpackemail'] = 'Dirección de correo electrónico';
$string['backpackemail_help'] = 'Dirección de correo electrónico asociada a tu cuenta de Mozilla OpenBadges Backpack';
$string['backpackemailaddexternalbackpackprovider'] = '<p>No se pudo encontrar un usuario que coincidiera con el Email \'<strong>{$a->useremail}</strong>\' de {$a->backpackproviderfullname}.</p><p>Asegúrese de que Usted tenga una cuenta en <a href="{$a->backpackprovidersiteurl}">{$a->backpackprovidersiteurl}</a> y \'<strong>{$a->useremail}</strong>\' sea añadido a su perfil.</p>';
$string['backpackemailaddexternalobp'] = '<p>No se puedo encontrar ningún usuario que coincidiera con la dirección de correo electrónico \'<strong>{$a}</strong>\' de Open Badge Passport.</p><p>Para añadir tu dirección de correo electrónico abre <a href="https://openbadgepassport.com">https://openbadgepassport.com</a> en tu navegador e inicia sesión. </p><p>Después de iniciar sesión sigue la ruta <strong><i>Mi cuenta > Ajustes de cuenta > Correos electrónicos</i></strong>.</p><p>Con la página <i>Correos electrónicos</i> abierta, añade \'<strong>{$a}</strong>\' en el campo \'Añadir nueva dirección de correo electrónico\' y guarda.</p>';
$string['backpackemailnotfound'] = 'No se pudo encontrar ningún usuario de Mozilla Backpack por la dirección de correo electrónico \'{$a}\'.';
$string['backpackgroups'] = 'Grupos de insignias';
$string['backpackgroups_help'] = 'Seleccione los grupos de insignia que se muestran en su monitor de insignias.';
$string['backpackprovideractions'] = 'Acciones';
$string['backpackprovideremailconfigureable'] = 'El usuario puede definir la dirección Email';
$string['backpackproviderfullname'] = 'Nombre completo';
$string['backpackprovidersettings'] = '{$a} -configuraciones';
$string['backpackprovidershortname'] = 'Nombre corto';
$string['backpackproviderurl'] = 'URL';
$string['backpackproviderurlinvalid'] = 'La URL no está definida apropiadamente; por favor, use la URL completa, como por ejemplo https://openbadgepassport.com/displayer/';
$string['backpackprovideruserwarning'] = 'Advertencia: {$a} usuarios ya tiene guardadas las asociaciones del Email para el proveedor. Cree  nuevos proveedores cuando añada nuevos servicios; no edite los proveedores existentes para apuntar a otros servicios.';
$string['backpacksettings'] = 'Ajustes de Backpack';
$string['badgeactions'] = 'Acciones';
$string['badgeblacklist'] = 'Ocultar insignias';
$string['badgecategories'] = 'Categorías';
$string['badgecreated'] = 'Creado en';
$string['badgecriteria'] = 'Reglas de concesión';
$string['badgecriteriahtml'] = 'Criterio';
$string['badgecriteriaurl'] = 'URL de los criterios';
$string['badgedescription'] = 'Descripción';
$string['badgedetails'] = 'Detalles de insignia';
$string['badgeemail'] = 'Plantilla de correo electrónico';
$string['badgeexpiresby'] = 'Expira en';
$string['badgeexport'] = 'Exportar insignias creadas anteriormente en Moodle';
$string['badgeexportdescription'] = 'Se hará una copia de todas las insignias seleccionadas en Open Badge Factory.';
$string['badgeexportzeroexportable'] = 'No se encontraron insignias exportables, o todas las insignias ya fueron exportadas.';
$string['badgehistory'] = 'Historial de concesión';
$string['badgeimage'] = 'Insignia';
$string['badgeissued'] = 'La insignia se emitió correctamente.';
$string['badgeissuedwhen'] = 'Esta insignia se concede automáticamente cuando se cumpla cualquiera de las siguientes reglas:';
$string['badgelist'] = 'Lista de insignias';
$string['badgelisttitle'] = 'Todas las insignias';
$string['badgename'] = 'Nombre';
$string['badgetags'] = 'Etiquetas';
$string['badgewasautomaticallyissued'] = 'Después de la revisión se concedió la insignia al beneficiario(s) {$a}.';
$string['blacklistbadge'] = 'No mostrar insignia';
$string['blacklistdescription'] = 'Seleccione las insignias que no quiere mostrar en su perfil. Puede ocultar cualquier insignia emitida por este entorno Moodle.';
$string['blacklistsaved'] = 'Mochila guardada.';
$string['cachedef_obf_assertions'] = 'Caché de afirmación de insignia OBF';
$string['cachedef_obf_assertions_backpacks'] = 'Caché de servicio externo Open Badge';
$string['cachedef_obf_pub_badge'] = 'Caché de datos específicos de eventos accesibles públicamente de OBF Badge';
$string['cancel'] = 'Cancelar';
$string['cannoteditcriterion'] = 'Esta regla no puede ser editada porque la insignia ya se ha emitido automáticamente aplicando esta regla.';
$string['categorysettings'] = 'Ajustes de categoría';
$string['certificateexpirationremindertask'] = 'recordatorio de caducidad del certificado';
$string['certrequestfailed'] = 'Hubo un error durante la solicitud de certificado desde la API';
$string['client'] = 'Cliente';
$string['clientdeleted'] = 'Conexión API eliminada';
$string['clientid'] = 'ID del cliente';
$string['clientid_help'] = 'ID del cliente de su cuenta';
$string['clientname'] = 'Nombre del cliente';
$string['clientsaved'] = 'Cliente guardado';
$string['clientsecret'] = 'Secreto del cliente';
$string['clientsecret_help'] = 'Ingrese a su cuenta de la Fábrica y vaya a  "Herramientas administrativas > API". Haga clic en "Generar nuevo secreto del cliente"';
$string['closepopup'] = 'Cerrar';
$string['completedbycriterion'] = 'por <strong>{$a}</strong>';
$string['configurecriteria'] = 'Configurar';
$string['confirmcriteriondeletion'] = '¿Está seguro de querer borrar esta regla de concesión?';
$string['confirmdelete'] = '¿Está Usted seguro de querer eliminar el registro {$a} ?';
$string['confirmrevokation'] = '¿Está Used seguro de querer revocar la insignia del usuario?';
$string['connect'] = 'Conectar {$a}';
$string['connectionisworking'] = 'OBF está conectado y funcionando. El certificado de cliente termina en <strong>{$a}</strong>.';
$string['connectionstatus'] = 'Estado de la conexión de Backpack.';
$string['coursealreadyincriterion'] = 'La regla de otorgamiento automático de esta insignia en este curso no puede ser editada, porque la combinación curso/insignia ya existe en otra regla que contiene varios cursos.';
$string['coursebadgelisttitle'] = 'Insignias relacionadas con este curso';
$string['coursecompletedby'] = 'Completado por';
$string['coursecompletionnotenabled'] = 'El seguimiento de la finalización no está habilitado en este curso. Habilítelo en <a href="{$a}">confguraciones del curso</a>.';
$string['courseeventhistory'] = 'Historia de Otorgamiento del Curso';
$string['courseobfbadges'] = 'Insignias';
$string['courserequired'] = 'Debe seleccionar al menos un curso';
$string['coursereset'] = 'Eliminar reglas de otorgamiento cuando el curso es reiniciado.';
$string['courseuserbadges'] = 'Insignias del usuario';
$string['createcsv'] = 'Descargar Historia de Insignias en CSV';
$string['criteria_3'] = 'Campos del perfil';
$string['criteria_3_help'] = 'Cuales campos del perfil necesitan llenarse, para disparar otorgamiento de insignia.';
$string['criteriaaddcourse'] = 'Añadir curso';
$string['criteriaaddendum'] = 'Adendo de criterios';
$string['criteriaaddendum_help'] = 'Una adición al criterio será añadida a la insignia emitida. La adición será mostrada debajo del criterio de la insignia. Nota: La sintaxis Markdown está soportada.';
$string['criteriaaddendumadd'] = 'Añadir un adendo de criterios';
$string['criteriaaddendumheader'] = 'Adendo de criterios';
$string['criteriacompletedwhen'] = 'Esta regla se cumple cuando...';
$string['criteriacompletedwhenall'] = 'Tienen que completarse todos los cursos siguientes:';
$string['criteriacompletedwhenany'] = 'Tiene que completarse cualquiera de los cursos siguientes:';
$string['criteriacompletionmethodall'] = 'Todos estos cursos están completados';
$string['criteriacompletionmethodany'] = 'Cualquiera de estos cursos es completado';
$string['criteriacompletionmethodprofileall'] = 'Todos los campos de perfil seleccionados han sido completados';
$string['criteriacompletionmethodprofileany'] = 'Cualquiera de los campos del perfil ha sido completado';
$string['criteriacourses'] = 'Criterios en esta regla';
$string['criteriapartofcourseset'] = 'Parte de criterio con varios cursos';
$string['criteriapreview'] = 'Vista previa de criterio de insignia';
$string['criteriatypeactivity'] = 'Completando un conjunto de actividades';
$string['criteriatypecourse'] = 'Completando un conjunto de cursos';
$string['criteriatypecourseset'] = 'Completando un conjunto de cursos';
$string['criteriatypeprofile'] = 'Completado del perfil';
$string['criteriatypetotaracertif'] = 'Completando un certificado';
$string['criteriatypetotaraprogram'] = 'Completando un programa';
$string['criteriatypeunknown'] = 'Criterio incompleto';
$string['criteriondeleted'] = 'Se eliminó regla para otorgamiento.';
$string['criterionsaved'] = 'Se guardó regla para otorgamiento.';
$string['csrexportfailed'] = 'Hubo un error al tratar de exportar la solicitud para firma del certificado';
$string['dateformatdate'] = '%Y-%m-%d';
$string['deauthenticate'] = 'Desconectar';
$string['deauthenticationsuccess'] = 'Desconectado exitosamente de Fábrica de Perfil Abierto';
$string['deleteclientconfirm'] = '¿Está seguro de querer eliminar esta conexión API?';
$string['deletecriterion'] = 'Eliminar regla de otorgamiento';
$string['disableassertioncache'] = 'Deshabilitar caché de afirmación de insignia';
$string['disableassertioncache_help'] = 'Las insignias en páginas de perfil no serán cacheadas. Las insignias emitidas desde afuera del entorno Moodle aparecerán en páginas de perfil sin retraso, pero puede afectar los tiempos de carga de páginas de perfil.';
$string['disablemoodlebadges'] = 'Deshabilitar el módulo de Insignias propio de Moodle. ADVERTENCIA: EL PERMITIR EL MÓDULO PROPIO DE MOODLE CAUSARÁ CONFLICTO';
$string['disablemoodlebadges_help'] = 'Las insignias antiguas de Moodle serán ocultadas de la interfaz del usuario, pero las insignias del usuario que sean guardadas a una Mochila todavía pueden mostrarse, y las insignias exportadas a la Fábrica de Insignias Abiertas todavía pueden ser otorgadas.';
$string['disconnect'] = 'Desconectar {$a}';
$string['displaymoodlebadges'] = 'Mostrar insignias de Moodle en perfiles';
$string['displaymoodlebadges_help'] = 'Las insignias antiguas de Moodle serán mostradas en páginas de perfil del usuario.';
$string['edit'] = 'Editar';
$string['editemailmessage'] = 'Editar mensaje Email';
$string['emailbadgerevokedbody'] = 'Una de sus insignias ganadas ({$a->revokedbadgename}) ha sido revocada por {$a->revokername}.';
$string['emailbadgerevokedsubject'] = 'Su insignia ha sido revocada';
$string['emailbody'] = 'Cuerpo del Email';
$string['emailfooter'] = 'Pie de página del email';
$string['emaillinktext'] = 'Prueba del enlace del Email';
$string['emailmessage'] = 'Mensaje Email';
$string['emailsubject'] = 'Asunto del Email';
$string['emailtemplatedescription'] = 'Aquí puede Usted configurar la plantilla por dfecto para el Email que será enviado al usuario que reciba eesta insignia. el Email puede ser personalizado antes de que la insignia sea otorgada.';
$string['emailtemplatesaved'] = 'La plantilla de Email fue guardada exitosamente.';
$string['emailverifytokenemailsubject'] = 'Verificación del Email';
$string['error:nosuchfield'] = 'No hay tal campo.';
$string['eventrevoked'] = 'Evento revocado por {$a}.';
$string['evidence'] = 'Evidencia';
$string['expired'] = 'Caducó';
$string['expiresby'] = 'Caduca';
$string['expiringcertificate'] = 'La clave API de Open Badge Factory expirará en <b>{$a->days}</b> días. Para renovar la clave API <a href="{$a->obfurl}">ingrese a Open Badge Factory</a> con la cuenta administrativa de su organización, vaya a Admin tools -> Edit Organisation Details -> More settings, genere el token de solicitud de firma de certificado (certificate signing request token) y renueve la clave API en  <a href="{$a->configurl}">Open Badges -> Settings -> OBF request token</a>.';
$string['expiringcertificatesubject'] = 'El certificado de cliente de Open Badge factoryestá expirando.';
$string['exportextrasettings'] = 'Configuraciones para exportar';
$string['exportsettings'] = 'Configuraciones para exportar';
$string['gradecriterion'] = 'con <strong>c calificación mínima de  {$a}</strong>';
$string['history'] = 'Historia de otorgamiento';
$string['historyrecipients'] = '{$a} recipientes';
$string['infoconnectapi'] = 'Seleccionar método de autenticación API. OAuth2 es preferido en el nivel de suscripción Pro.';
$string['invalidcriterion'] = 'LA regla de otorgamiento es inválida. Uno o más requisitos no se cumplen y la insignia';
$string['invalidtab'] = 'Página no encontrada';
$string['issuancedetails'] = 'Detalles de la emisión';
$string['issue'] = 'Emitir insignia';
$string['issueandexpiration'] = 'Fechas de emisión y caducidad';
$string['issuebadge'] = 'Emitir una insignia';
$string['issuedfrom'] = 'Emitidas desde';
$string['issuedon'] = 'Emitida en';
$string['issuer'] = 'Emisor';
$string['issuerdescription'] = 'Descripción';
$string['issuerdetails'] = 'Detalles del emisor';
$string['issueremail'] = 'Email';
$string['issuername'] = 'Nombre';
$string['issuerroles'] = 'Roles del emisor';
$string['issuerroles_help'] = 'Autorizar roles para emitir insignias para este cliente:';
$string['issuerurl'] = 'URL';
$string['issuethisbadge'] = 'Emitir esta insignia';
$string['localevents'] = 'La historia de otorgamientos solamente muestra insignias emitidas desde este sistema.';
$string['makeexporteddrafts'] = 'Las insignias exportadas son borradores por defecto';
$string['messageprovider:revoked'] = 'La insignia emitida está revocada';
$string['minimumgrade'] = 'Calificación mínima';
$string['nobackpackgroups'] = 'Sin grupos de insignia pública en su mochila. Cree al menos un grupo público en su mochila.';
$string['nobadgehistory'] = 'Esta insignia todavía no ha sido emitida aun.';
$string['nobadges'] = 'Todavía sin insignias.';
$string['nobadgesincourse'] = 'Todavía sin insignias relacionadas.';
$string['nobadgestoexport'] = 'Sin insignias para exportar.';
$string['nocourseswithcompletionenabled'] = 'No hay cursos con finalización habilitada.';
$string['nocriteriayet'] = 'Todavía no se han creado reglas de otorgamiento automático.';
$string['nohistory'] = 'Todavía sin insignias emitidas.';
$string['noparticipants'] = 'Sin participantes.';
$string['nouserbadges'] = 'Todavía sin insignias ganadas.';
$string['novalidcourses'] = 'No hay cursos a los que les falten reglas para otorgar con respecto a esta insignia.';
$string['numberofbadgesmany'] = 'insignias';
$string['numberofbadgessingle'] = 'insignia';
$string['obf'] = 'Insignias Abiertas';
$string['obf:configure'] = 'Configurar configuraciones del cliente de OBF';
$string['obf:configureuser'] = 'Configurar las configuraciones propias de Insignia Abierta';
$string['obf:earnbadge'] = 'Ganarse una Insignia Abierta';
$string['obf:editcriterion'] = 'Editar criterio de insignia';
$string['obf:issuebadge'] = 'Emitirle insignia a un usuario';
$string['obf:revokeallevents'] = 'Revocar evento';
$string['obf:revokecourseevents'] = 'Revocar un evento, que fue emitido automáticamente basándose en criterios del curso.';
$string['obf:seeparticipantbadges'] = 'Ver las insignias de participantes del curso';
$string['obf:viewallbadges'] = 'Ver insignias disponibles';
$string['obf:viewallevents'] = 'Ver eventos de emisión de insignia';
$string['obf:viewbackpack'] = 'Ver mochilas';
$string['obf:viewcourseevents'] = 'Ver eventos de emisión de insignia de curso';
$string['obf:viewdetails'] = 'Ver detalles de insignia';
$string['obf:viewhistory'] = 'Ver historia de emisión de insignia';
$string['obf:viewownbackpack'] = 'Ver mochila propia';
$string['obfconnectionconfig'] = 'Configuraciones de conexión API antiguas heredadas';
$string['obfurl'] = 'URL de API';
$string['obfurl_help'] = 'URL para la Fábrica de donde es esta cuenta.';
$string['obfuserpreferences'] = 'Configuraciones de Insignia Abierta';
$string['obpbackpacksettings'] = 'Pasaporte de Insignia Abierta - configuraciones';
$string['personalbadgecloudservices'] = 'Origen del visualizador de insignia';
$string['pkidirnotwritable'] = 'El directorio del certificado <i>{$a}</i> debería ser escribible para el usuario del servidor web.';
$string['pluginname'] = 'Fábrica de Insignia Abierta';
$string['previewbadge'] = 'Previsualizar insignia';
$string['previewcriteria'] = 'Previsualizar';
$string['previewemail'] = 'Previsualizar';
$string['profilebadgelist'] = 'Insignias';
$string['profilebadgelistbackpackprovider'] = '{$a} insignias';
$string['profilebadgelistmoz'] = 'Insignias de Mochila Mozilla';
$string['profilebadgelistobp'] = 'Insignias Pasaporte de Insignia Abierta';
$string['pubkeyextractionfailed'] = 'Hubo un error al extraer la clave pública del certificado.';
$string['pubkeyrequestfailed'] = 'Hubo un error al solicitar la clave pública de la API';
$string['readmeenablecompletion'] = 'Criterio para ganar insignia';
$string['readmeenablecompletion_help'] = '<p>Para que funcione apropiadamente el criterio para ganar insignia automáticamente, tiene que estar habilitado el seguimiento de la finalización. </p><p>La forma más fácil de habilitar el seguimiento de finalización es:</p><ol><li>Localice el bloque de "Configuraciones".</li><li>Escriba "enablecompletion" dentro de la caja de búsqueda, y elija \'Buscar\'.</li><li>Habilitar seguimiento de finalización: Si.</li><li>Opcional pero recomendable: Habilitar por defecto el seguimiento de finalización en configuraciones del curso.</li></ol><strong>Configuraciones del curso</strong><p>Si el seguimiento de la finalización no está habilitado en las configuraciones por defecto del curso, el seguimiento de la finalización puede ser habilitado vía la página de <i>Administración del curso->Editar configuraciones</i> .</p>';
$string['recipientcandidates'] = 'Usuarios que coincidan con la búsqueda';
$string['recipients'] = 'Recipientes';
$string['requesttoken'] = 'Token de solicitud OBF';
$string['resetfilter'] = 'Reiniciar filtro';
$string['reviewcriterionaftersave'] = 'Revisar regla después de guardar';
$string['reviewcriterionaftersave_help'] = 'Si esta casilla está activada, la regla será revisada después de guardarla y si alguien ya ha cumplido con esta regla anteriormente, entonces esta insignia será otorgada automáticamente.';
$string['revoke'] = 'Revocar';
$string['revokeuserbadges'] = 'Revocar insignias del usuario';
$string['saveconfiguration'] = 'Continuar';
$string['savecriteria'] = 'Guardar';
$string['savesettings'] = 'Guardar';
$string['selectactivity'] = 'Seleccionar actividad';
$string['selectatleastonerecipient'] = 'Seleccionar al menos un recipiente';
$string['selectbadge'] = 'Seleccionar insignia';
$string['selectbadgestoexport'] = 'Seleccionar las insignias que desea exportar a la Fábrica de Insignia Abierta';
$string['selectcompletionmethod'] = 'Seleccionar método de finalización';
$string['selectcompletionmethod_help'] = 'Seleccionar el método por el que se gana la insignia.';
$string['selectcourses'] = 'Seleccionar cursos';
$string['selectcourses_help'] = 'Seleccione los cursos que deben de completarse para recibir autmáticamente esta insignia.';
$string['selectcriteriatype'] = 'Seleccionar...';
$string['selectcriteriatype_help'] = 'Seleccionar el método por el que se gana la insignia.';
$string['selectprogram'] = 'Seleccionar programa';
$string['selectrecipients'] = 'Seleccionar recipientes';
$string['settings'] = 'Configuraciones';
$string['settingssaved'] = 'Configuraciones guardadas';
$string['showassertion'] = 'Detalles';
$string['showbadgecriteria'] = 'Criterio de insignia abierta';
$string['showbadges'] = 'Mostrar insignias';
$string['showbadgesonmyprofile'] = 'Mostrar insignias en página de perfil';
$string['showcategories'] = 'Mostrar insignias de estas categorías:';
$string['showconnectionconfig'] = 'Yo sé que está funcionando, pero déjame cambiar el token de cualquier forma.';
$string['showmorerecipients'] = 'más';
$string['siteadmin'] = 'Administración del Sitio';
$string['testbackpackapiurlexception'] = '¡Error al probar API via <a href="{$a->url}">{$a->url}</a> ! Código del error: {$a->errorcode}.';
$string['toearnthisbadge'] = 'Para ganar esta insignia el curso debe estar finalizado';
$string['tokendecryptionfailed'] = 'Falló el des-encriptado del token solicitado. Asegúrese de pegar completo el token de solicitud que firma el certificado.';
$string['totaraprogram'] = 'Programa';
$string['totaraprogramexpiresbybadge'] = 'Caducidad de propiedades de insignia';
$string['totaraprogramexpiresbycertificate'] = 'Caducidad de propiedades de certificado';
$string['totaraprogramselectexpires'] = 'Seleccionar cual configuración se usa para otorgar insignias';
$string['unknowncriterion'] = 'Criterio incompleto';
$string['upgradelegacyapi'] = 'Sugerencia: Usted puede cambiar a autenticación OAuth basada en API en el nivel de suscripción Pro. Comience por quitar esta conexión.';
$string['urlgroup'] = 'URL';
$string['urlgroup_help'] = '<p>Si Usted no está usando el servidor por defecto openbadgefactory.com. Configure aquí a dirección del servicio.</p>';
$string['useremailupdater'] = 'Actualizador de Email del usuario';
$string['userpreferences'] = 'Configuraciones del usuario';
$string['userpreferencessaved'] = 'Configuraciones del usuario guardadas';
$string['userscanmanagedisplayofbadges'] = 'Los usuarios pueden elegir si quieren mostrar insignias';
$string['usersdisplaybadges'] = 'Mostrar insignias del usuario';
$string['usersforcedtodisplaybadges'] = 'Las insignias son mostradas en página del perfil';
$string['usersnotallowedtodisplaybadges'] = 'Las insignias no son mostradas en página del perfil';
$string['verification_failed'] = 'Falló la verificación de mochila. Razón: {$a}';
$string['verifytoken'] = 'Token';
$string['verifytokenbutton'] = 'Verificar';
$string['verifytokendescription'] = 'Se ha enviado un Email a la dirección proporcionada. Revise su correo para localizar un código de verificación.';
$string['warningcannoteditafterreview'] = 'Tenga en cuanta que si la insignia es otorgada cuando estas reglas están siendo revisadas, las reglas ya no podrán ser editadas. Una vez que la insignia haya sido otorgada automáticamente a cuando menos una persona, la edición de las reglas será prohibida. Así es que asegúrese de que las reglas estén correctamente configuradas antes de revisarlas.';
