define("core/local/process_monitor/process",["exports","core/reactive","core/local/process_monitor/manager"],(function(_exports,_reactive,_manager){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;
/**
   * The process motnitor's process reactive component.
   *
   * @module     core/local/process_monitor/process
   * @class      core/local/process_monitor/process
   * @copyright  2022 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class _default extends _reactive.BaseComponent{create(){this.name="process_monitor_process",this.selectors={CLOSE:'[data-action="closeProcess"]',ERROR:'[data-for="error"]',PROGRESSBAR:"progress",NAME:'[data-for="name"]'},this.classes={HIDE:"d-none"},this.id=this.element.dataset.id}static init(query,selectors){return new this({element:document.querySelector(query),reactive:_manager.manager,selectors:selectors})}stateReady(state){this._refreshItem({state:state,element:state.queue.get(this.id)}),this.addEventListener(this.getElement(this.selectors.CLOSE),"click",this._removeProcess)}getWatchers(){return[{watch:"queue[".concat(this.id,"]:updated"),handler:this._refreshItem},{watch:"queue[".concat(this.id,"]:deleted"),handler:this.remove}]}async _refreshItem(_ref){let{element:element}=_ref;this.getElement(this.selectors.NAME).innerHTML=element.name;const progressbar=this.getElement(this.selectors.PROGRESSBAR);progressbar.classList.toggle(this.classes.HIDE,element.finished),progressbar.value=element.percentage;this.getElement(this.selectors.CLOSE).classList.toggle(this.classes.HIDE,!element.error);const error=this.getElement(this.selectors.ERROR);error.innerHTML=element.error,error.classList.toggle(this.classes.HIDE,!element.error)}_removeProcess(){this.reactive.dispatch("removeProcess",this.id)}}return _exports.default=_default,_exports.default}));

//# sourceMappingURL=process.min.js.map